const RESOLVER_GATEWAY = "https://xlmns.com/v1/";

console.log("XLM Resolver Active - Monitoring .xlm domains");

// Main interception for navigations
chrome.webNavigation.onBeforeNavigate.addListener((details) => {
  if (details.frameId !== 0) return; // Only main frame

  const url = details.url.toLowerCase();

  // Match full domain ending in .xlm (with or without scheme/protocol)
  const xlmMatch = url.match(/^(?:https?:\/\/)?([^\/]+\.xlm)(?:\/.*)?$/i);
  if (xlmMatch) {
    const domain = xlmMatch[1];
    const redirectUrl = RESOLVER_GATEWAY + domain;

    chrome.tabs.update(details.tabId, { url: redirectUrl });
    console.log(`Redirecting ${url} → ${redirectUrl}`);
  }
});

// Fallback for DNS failures (when Chrome tries http://domain.xlm and it fails)
chrome.webNavigation.onErrorOccurred.addListener((details) => {
  if (details.frameId !== 0) return;
  if (!details.error.includes('NAME_NOT_RESOLVED')) return;

  const url = details.url.toLowerCase();

  // Extract domain from failed attempt (handles http:// or bare)
  const xlmMatch = url.match(/^(?:https?:\/\/)?([^\/]+\.xlm)(?:\/.*)?$/i);
  if (xlmMatch) {
    const domain = xlmMatch[1];
    const redirectUrl = RESOLVER_GATEWAY + domain;

    chrome.tabs.update(details.tabId, { url: redirectUrl });
    console.log(`Fallback redirect on error: ${url} → ${redirectUrl}`);
  }
});